# Installation von INFOSERVER

> **NOTE:**
> Alle Scripte müssen als Administrator ausgeführt werden!

1. **Installation über LS-Updater**
   Den LS-Updater über den Link [https://landau-software.de/LSUpdateInstaller](https://landau-software.de/LSUpdateInstaller) installieren und Registrieren. Der Registrierung der Machinde oder des Kunden muss zusätzlich das Modul `UPD_APP_INFOSERVER` zugewiesen werden. Ggf. muss der Updater nach diesen Änderungen über `Einstellungen -> Beenden` beendet und anschließend neu gestartet werden. Anschließend kann die Anwendung `INFOSERVER` und ggf. die Anwendungen `ÌS STATUS` und `IS USEREDITOR` installiert werden.

2. **Installationsordner im Explorer Öffnen**
   Der Server wird im Pfad `C:\INFOSERVER\` installiert.

3. **Registrieren**
   Das Script `register.bat` als Administrator ausführen und die Daten für die Registrierung eingeben. Anschließend wird in der Konsole die ID der Registrierung angezeigt. Diese muss freigegeben werden. Es können zusätzliche Module wie `IS_SMARTKIS` hinzugefügt werden.

4. **Standardeinstellungen erstellen**
   Script `run in console - verbose.bat` ausführen und anschließend den Server über die Taste `ESC` beenden.

5. **Anpassen der Einstellungen**
   > **NOTE:**
   > Zur Konfiguration sind einige Punkte zu beachten. Diese sind im Abschnitt [Einstellungen](#einstellungen) zu finden.

   Die Datei `C:\INFOSERVER\Settings.json` sollte entsprechend der gewünschten Konfiguration angepasst werden. Nach dem Speichern können diese über das Script `run in console - verbose.bat` überprüft werden. Der Server kann über die Taste `ESC` beendet werden. Die Tasten `V` (Verbose), `N` (Normal) und `M` (Minimal) können verwendet werden, um den Detailgrad der Ausgabe zu ändern. Nach der Anpassung der Einstellungen kann der Server über die Taste `R` neu gestartet werden. Das beenden der Anwendung ist nicht nötig.

   Die Korrekte Ausführung kann im Webbrowser über die Adresse [`http://127.0.0.1:9300/status`](http://127.0.0.1:9300/status) überprüft werden.

6. **Firewall einstellen**
   Der Server verwendet Standardmäßig die Ports `TCP 9300,9301` und `UDP 9300`. Diese müssen als Ausnahmen hinterlegt werden. Sie können über das Script `firewall.bat` hinterlegt werden.

7. **Installation als Windows Dienst**
   Um die Anwendung als Windows dienst zu registrieren muss das Script `install service.bat` ausgeführt werden. Der Server wird im Anschluss gestartet. Die Ausgabe wird in den Windows EventLog geschrieben. Dieser zeigt bspw. Fehler an.

   > **TIPP:** Weitere Informationen zum EventLog sind im Abschnitt [Fehlerbehebung](#fehlerbehebung) zu finden.

## Einstellungen

> **NOTE:**
> Wenn der Server als Windows-Dienst ausgeführt wird, wird `%WINDIR%\System32\` als Arbeitsverzeichnis verwendet. Während des Starts versucht der Server dieses Verzeichnis auf den Installationspfad (meistens ``C:\INFOSERVER\`) festzulegen. Um Fehler zu vermeiden, sollten relative Pfade in der Konfiguration vermieden werden. Dies bezieht sich bspw. auf die Pfade von `secure_certificate_file` oder `additional->ini_path`.

### Beispieldatei

```json
{
    "additional": {
        "database_cache_enabled": false,
        "database_cache_max_age_seconds": 10,
        "dolfi1920_createEinzelteilIfStoreDoesNotHaveThisProduct": false,
        "infoman_directory": "C:\\INFOMAN32\\",
        "ini_is_kasse": false,
        "ini_path": "C:\\INFOMAN32\\infoman.ini",
        "server_discovery_enabled": true,
        "transfer": {
            "lsTransfer_exe": "C:\\INFOMAN32\\Transfer.exe",
            "lsTransfer_exe_defeault_args": "",
            "rootPath": "C:\\INFOMAN32\\Transfer\\"
        },
        "user_and_password_required": true
    },
    "admin_password": "admin",
    "admin_username": "admin",
    "buffer_chunck_size": 16384,
    "buffer_max_size": 20971520,
    "connection_watcher_timeout": 5000,
    "keep_alive_timeout_sec": 10,
    "redirect_to_secure_connection": true,
    "secure_certificate_file": "server_certificate.pem",
    "secure_server_port": 9301,
    "server_port": 9300
}
```

### Felder

> **NOTE:** Einstellungen, welche für die Konfiguration von INFOSERVER vorgesehen sind, befinden sich im Unterknoten `additional` der Datei `Settings.json`.

| Name                                                      | Hinweis                                                                                                                          |
| :-------------------------------------------------------- | :------------------------------------------------------------------------------------------------------------------------------- |
| `database_cache_enabled`                                  | Gibt an, ob Datenbankanfragen über einen Cache laufen sollen. Dies ist bei langsamen Netzlaufwerken sinnvoll.                    |
| `database_cache_max_age_seconds`                          | Maximale Alter für Einträge im Cache                                                                                             |
| `dolfi1920_createEinzelteilIfStoreDoesNotHaveThisProduct` | Gibt an, ob neue Einzelteile erstellt werden sollen, wenn diese nicht in der Datenbank vorhanden sind.                           |
| `infoman_directory`                                       | Pfad zu den Bibliotheken von INFOMAN. Dieser Pfad muss alle INFOMAN DLLs beinhalten.                                             |
| `ini_is_kasse`                                            | Gibt an, ob die INI für eine Kasse ist. Diese Funktion wird derzeit nicht unterstützt.                                           |
| `ini_path`                                                | Pfad zur `INFOMAN.ini`-Datei. **Hinweise im Abschnitt [`INFOMAN.INI`](#infoman-ini) beachten!**                                  |
| `server_discovery_enabled`                                | Gibt an, ob der Server auf Suchanfragen reagiert. Diese erlauben die automatische Konfiguration von UserEditor und StatusViewer. |
| `transfer`                                                | Einstellungen für die Datenübertragung mit LS-Transfer.                                                                          |
| `user_and_password_required`                              | Gibt an, ob Anfragen nur mit einem gültigen User möglich sind.                                                                   |

#### INFOMAN.INI

Da INFOSERVER als Windows Dienst ausgeführt wird, kann dieser ausschließlich auf dem Laufwerk `C:\` ausgeführt werden. Aus diesem Grund ist es nicht möglich, Relative Pfade in der `INFOMAN.ini` zu verwenden. Alle Pfade müssen als absolute Pfade angeben werden. Dies schließt bspw. die Konfiguration der Datenbankdateien ein.

Es wird empfohlen, die `INFOMAN.ini`-Datei in den `C:\INFOSERVER\`-Ordner zu kopieren, die Pfade auf absolute Pfade zu ändern und die Datei `C:\INFOSERVER\INFOMAN.ini` als `ini_path` Wert in der Konfiguration zu hinterlegen. Da während der Ausführung als Windows Service keine Userspeziefischen Netzlaufwerke verbunden werden, sollten diese vermieden werden. Alternativ können diese über `Dieser Computer -> Netzlaufwerk verbinden` unabhängig von der Benutzeranmeldung verbunden werden.

## Fehlerbehebung

Um die Fehlersuche zu erleichtern, werden details in die Serverkonsole geschrieben. Diese Ausgabe ist während der Ausführung als Windows Dienst nicht einsehbar. Aus diesem Grund schreibt der INFOSERVER diese Ereignisse in den Windows EventLog. Dieser ist unter dem Pfad `EventLog -> Anwendungs- und Dienstprotokolle -> LS-INFOSERVER` zu finden. Wenn diese Ausgabe nicht ausreicht, kann der Dienst beendet werden und der Server über das Script `C:\INFOSERVER\run in console - verbose.bat` gestartet werden. Die Ausgabe wird in diesem Fall in der Konsole angezeigt.
